/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.instance.InstancerProvider;
import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11659;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class FlapStuffs {
    public static final int FLAP_COUNT = 4;
    public static final float X_OFFSET = 0.0046875f;
    public static final float SEGMENT_STEP = -0.190625f;
    public static final class_243 TUNNEL_PIVOT = VecHelper.voxelSpace(0.0, 10.0, 1.0);
    public static final class_243 FUNNEL_PIVOT = VecHelper.voxelSpace(0.0, 10.0, 9.5);

    public static FlapsRenderState getFlapsRenderState(SuperByteBuffer flapBuffer, class_243 pivot, class_2350 funnelFacing, float flapness, float zOffset, int light) {
        float horizontalAngle = (float)Math.PI / 180 * AngleHelper.horizontalAngle(funnelFacing.method_10153());
        float[] angles = new float[4];
        for (int segment = 0; segment < 4; ++segment) {
            angles[segment] = (float)Math.PI / 180 * FlapStuffs.flapAngle(flapness, segment);
        }
        class_4587.class_4665[] entries = new class_4587.class_4665[4];
        return new FlapsRenderState(flapBuffer, pivot, zOffset, light, horizontalAngle, angles, entries);
    }

    public static float flapAngle(float flapness, int segment) {
        float intensity = segment == 3 ? 1.5f : (float)(segment + 1);
        float abs = Math.abs(flapness);
        float flapAngle = class_3532.method_15374((double)((float)((double)(1.0f - abs) * Math.PI * (double)intensity))) * 30.0f * flapness;
        if (flapness < 0.0f) {
            flapAngle *= 0.5f;
        }
        return flapAngle;
    }

    public static Matrix4f commonTransform(class_2338 visualPosition, class_2350 side, float baseZOffset) {
        float horizontalAngle = AngleHelper.horizontalAngle(side.method_10153());
        return new Matrix4f().translate((float)visualPosition.method_10263(), (float)visualPosition.method_10264(), (float)visualPosition.method_10260()).translate(0.5f, 0.5f, 0.5f).rotateY((float)Math.PI / 180 * horizontalAngle).translate(-0.5f, -0.5f, -0.5f).translate(0.0046875f, 0.0f, baseZOffset);
    }

    @Environment(value=EnvType.CLIENT)
    public record FlapsRenderState(SuperByteBuffer model, class_243 pivot, float zOffset, int light, float horizontalAngle, float[] angles, class_4587.class_4665[] entries) implements class_11659.class_11660
    {
        public void render(class_1921 layer, class_4587 matrices, class_11659 queue) {
            matrices.method_22903();
            matrices.method_46416(0.5f, 0.5f, 0.5f);
            matrices.method_22907((Quaternionfc)class_7833.field_40716.rotation(this.horizontalAngle));
            matrices.method_46416(-0.5f, -0.5f, -0.5f);
            matrices.method_46416(0.0046875f, 0.0f, this.zOffset);
            for (int segment = 0; segment < 4; ++segment) {
                matrices.method_22903();
                matrices.method_22904(this.pivot.field_1352, this.pivot.field_1351, this.pivot.field_1350);
                matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(this.angles[segment]));
                matrices.method_22904(-this.pivot.field_1352, -this.pivot.field_1351, -this.pivot.field_1350);
                this.entries[segment] = matrices.method_23760().method_56822();
                matrices.method_22909();
                matrices.method_46416(-0.190625f, 0.0f, 0.0f);
            }
            matrices.method_22909();
            queue.method_73483(matrices, layer, (class_11659.class_11660)this);
        }

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            for (int segment = 0; segment < 4; ++segment) {
                this.model.light(this.light).renderInto(this.entries[segment], vertexConsumer);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Visual {
        private final TransformedInstance[] flaps;
        private final Matrix4f commonTransform = new Matrix4f();
        private final class_243 pivot;

        public Visual(InstancerProvider instancerProvider, Matrix4fc commonTransform, class_243 pivot, Model flapModel) {
            this.pivot = pivot;
            this.commonTransform.set(commonTransform).translate((float)pivot.field_1352, (float)pivot.field_1351, (float)pivot.field_1350);
            this.flaps = new TransformedInstance[4];
            instancerProvider.instancer(InstanceTypes.TRANSFORMED, flapModel).createInstances(this.flaps);
        }

        public void update(float f) {
            for (int segment = 0; segment < 4; ++segment) {
                TransformedInstance flap = this.flaps[segment];
                ((TransformedInstance)((TransformedInstance)flap.setTransform((Matrix4fc)this.commonTransform).rotateXDegrees(FlapStuffs.flapAngle(f, segment))).translateBack(this.pivot)).translate((float)segment * -0.190625f, 0.0f, 0.0f).setChanged();
            }
        }

        public void delete() {
            for (TransformedInstance flap : this.flaps) {
                flap.delete();
            }
        }

        public void updateLight(int light) {
            for (TransformedInstance flap : this.flaps) {
                flap.light(light).setChanged();
            }
        }

        public void collectCrumblingInstances(Consumer<Instance> consumer) {
            for (TransformedInstance flap : this.flaps) {
                consumer.accept(flap);
            }
        }
    }
}

